/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.monitor.globalsetting.service.impl;

import com.tp_link.eap.configuration.Configuration;
import com.tp_link.eap.domain.eap.Ap;
import com.tp_link.eap.domain.eap.bean.Radio;
import com.tp_link.eap.domain.eap.bean.TxPowerLevel;
import com.tp_link.eap.domain.eapstats.DeviceMisc;
import com.tp_link.eap.domain.global.OperationResult;
import com.tp_link.eap.domain.globalsetting.Region;
import com.tp_link.eap.domain.globalsetting.bean.RegionWireParam;
import com.tp_link.eap.monitor.globalsetting.repo.RegionRepository;
import com.tp_link.eap.monitor.globalsetting.service.e;
import com.tp_link.eap.monitor.globalsetting.service.g;
import com.tp_link.eap.multicontrol.ControlType;
import com.tp_link.eap.multicontrol.OperationResponse;
import com.tp_link.eap.multicontrol.ResErrorCode;
import com.tp_link.eap.util.j.a;
import com.tp_link.eap.util.j.b;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="regionService")
public class RegionServiceImpl
implements e {
    @Autowired
    private RegionRepository a;
    @Autowired
    private com.tp_link.eap.monitor.record.service.a b;
    @Autowired
    private com.tp_link.eap.monitor.monitor.service.b c;
    @Autowired
    private g d;
    private Logger e = LoggerFactory.getLogger(this.getClass());
    private static final Configuration f = com.tp_link.eap.configuration.a.a((String)"eap.properties");
    private static final Integer g = f.getEapCustomizeFlag();

    @Override
    public Region getRegion() {
        String string = com.tp_link.eap.d.b.a();
        List<Region> list = this.a.findBySite(string);
        if (list == null || list.isEmpty()) {
            Region region = new Region("China");
            com.tp_link.eap.d.b.g((String)string);
            this.a.save(region);
            return region;
        }
        return list.get(0);
    }

    @Override
    public String getCountry(String site) {
        List<Region> list = this.a.findBySite(site);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0).getCountry();
    }

    @Override
    public OperationResult addRegion(String country, boolean restore) {
        if (this.a() && com.tp_link.eap.util.j.a.a((String)country).intValue() != this.b()) {
            return new OperationResult(false, "The version of the software does not support the modification of Region.");
        }
        if (country == null) {
            return com.tp_link.eap.util.e.aX;
        }
        String string = com.tp_link.eap.d.b.a();
        com.tp_link.eap.d.b.g((String)string);
        List<Region> list = this.a.findBySite(string);
        if (!CollectionUtils.isEmpty(list)) {
            this.a.delete(list);
        }
        Region region = new Region(country);
        region.setSite(string);
        this.a.save(region);
        com.tp_link.eap.util.j.b.b((String)country, (boolean)true);
        com.tp_link.eap.util.j.b.b((String)country, (boolean)false);
        if (!CollectionUtils.isEmpty(list)) {
            this.adjustApChannel(list.get(0).getCountry(), country, null);
        }
        if (!restore) {
            this.b.refreshRecord("region", com.tp_link.eap.util.j.a.a((String)country));
        }
        return com.tp_link.eap.util.e.bc;
    }

    @Override
    public Region getCustomizeCountry() {
        if (!this.a()) {
            return null;
        }
        String string = com.tp_link.eap.util.j.a.a((Integer)this.b());
        return new Region(string);
    }

    @Override
    public OperationResult deleteBySite() {
        String string = com.tp_link.eap.d.b.a();
        List<Region> list = this.a.findBySite(string);
        if (!CollectionUtils.isEmpty(list)) {
            this.a.delete(list);
        }
        return com.tp_link.eap.util.e.bc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustApChannel(String oldRegion, String region, List<Ap> adjustAps) {
        if (oldRegion.equals(region)) {
            return;
        }
        boolean bl = com.tp_link.eap.util.j.b.c((String)region, (boolean)true);
        List<Ap> list = adjustAps == null ? this.c.getSiteAdoptedAps(com.tp_link.eap.d.b.a()) : adjustAps;
        List list2 = com.tp_link.eap.util.j.b.b((String)oldRegion, (boolean)true);
        List list3 = com.tp_link.eap.util.j.b.b((String)region, (boolean)true);
        boolean bl2 = com.tp_link.eap.util.j.b.a((String)oldRegion, (boolean)false);
        boolean bl3 = com.tp_link.eap.util.j.b.a((String)region, (boolean)false);
        boolean bl4 = com.tp_link.eap.util.j.b.d((String)region);
        boolean bl5 = com.tp_link.eap.util.j.b.c((String)region, (boolean)false);
        List list4 = com.tp_link.eap.util.j.b.b((String)region, (boolean)false);
        List list5 = com.tp_link.eap.util.j.b.b((String)oldRegion, (boolean)false);
        if (!CollectionUtils.isEmpty(list)) {
            for (Ap ap : list) {
                Object object;
                Object object2 = object = com.tp_link.eap.b.b.a.a((String)ap.getMac());
                synchronized (object2) {
                    int n2;
                    int n3;
                    String string;
                    Integer n4;
                    Integer n5;
                    ap = this.c.getAp(ap.getId());
                    Radio radio = ap.getRadio();
                    if (radio != null) {
                        n5 = Integer.valueOf(radio.getChannelWidth());
                        if (!(n5 != 3 && n5 != 4 || bl)) {
                            radio.setChannelWidth(String.valueOf(2));
                        }
                        n4 = Integer.valueOf(radio.getChannel());
                        string = this.a(n4, (List<RegionWireParam>)list2);
                        n3 = this.a(string, (List<RegionWireParam>)list3);
                        radio.setChannel(String.valueOf(n3));
                        n2 = this.a(n3, string, list3);
                        radio.setTxPower(Integer.valueOf(this.a((int)radio.getTxPowerLevel(), radio.getTxPower(), n2)));
                    }
                    if (bl3 && (radio = ap.getRadio5g()) != null) {
                        n5 = Integer.valueOf(radio.getChannelWidth());
                        if (com.tp_link.eap.util.e.b((DeviceMisc)ap.getDeviceMisc(), (String)ap.getModel())) {
                            if (!bl4) {
                                if (!bl2 || n5 == 6 || n5 == 5) {
                                    radio.setChannelWidth(String.valueOf(4));
                                }
                            } else if (!bl2 || n5 == 4) {
                                radio.setChannelWidth(String.valueOf(6));
                            }
                        } else if (!bl2) {
                            radio.setChannelWidth(String.valueOf(2));
                        } else if (!(n5 != 3 && n5 != 4 || bl5)) {
                            radio.setChannelWidth(String.valueOf(2));
                        }
                        n4 = Integer.valueOf(radio.getChannel());
                        string = this.a(n4, (List<RegionWireParam>)list5);
                        n3 = this.a(string, (List<RegionWireParam>)list4);
                        radio.setChannel(String.valueOf(n3));
                        n2 = this.a(n3, string, list4);
                        radio.setTxPower(Integer.valueOf(this.a((int)radio.getTxPowerLevel(), radio.getTxPower(), n2)));
                    }
                    radio = ap.getRadio();
                    n5 = com.tp_link.eap.a.a.a((Radio)radio, (boolean)true);
                    this.b.refreshRecord(ap.getMac(), "wirelessBasic_2G", n5);
                    if (bl3) {
                        radio = ap.getRadio5g();
                        n5 = com.tp_link.eap.a.a.a((Radio)radio, (boolean)false);
                        this.b.refreshRecord(ap.getMac(), "wirelessBasic_5G", n5);
                    }
                    this.c.refreshAp(ap);
                }
            }
        }
    }

    private String a(int n2, List<RegionWireParam> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        for (RegionWireParam regionWireParam : list) {
            if (regionWireParam.getValue() != n2) continue;
            return regionWireParam.getChannelName();
        }
        return null;
    }

    private int a(String string, List<RegionWireParam> list) {
        if (CollectionUtils.isEmpty(list)) {
            return 0;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (!list.get(i2).getChannelName().equals(string)) continue;
            return i2 + 1;
        }
        return 0;
    }

    private int a(int n2, String string, List<RegionWireParam> list) {
        if (CollectionUtils.isEmpty(list)) {
            return 0;
        }
        if (n2 == 0) {
            int n3 = 0;
            for (RegionWireParam regionWireParam : list) {
                if (regionWireParam.getMaxTxPower() <= n3) continue;
                n3 = regionWireParam.getMaxTxPower();
            }
            return n3;
        }
        for (RegionWireParam regionWireParam : list) {
            if (!regionWireParam.getChannelName().equals(string)) continue;
            return regionWireParam.getMaxTxPower();
        }
        return 0;
    }

    private boolean a() {
        return g != -1;
    }

    private int b() {
        return (g - 2) / 3;
    }

    private int a(int n2, int n3, int n4) {
        if (n3 > n4) {
            return n4;
        }
        if (n2 == TxPowerLevel.HIGH.getLevel()) {
            return n4;
        }
        if (n2 == TxPowerLevel.MEDIUM.getLevel()) {
            return n4 * 60 / 100;
        }
        if (n2 == TxPowerLevel.LOW.getLevel()) {
            return n4 * 20 / 100;
        }
        return n3;
    }

    public static void main(String[] args) {
        int n2 = 276;
        System.out.println("EAP_FLAG : " + (n2 * 3 + 2));
    }

    @Override
    public List<List<RegionWireParam>> getRegionWireParams(Integer region) {
        ArrayList<List<RegionWireParam>> arrayList = new ArrayList<List<RegionWireParam>>();
        String string = com.tp_link.eap.util.j.a.a((Integer)region);
        List list = com.tp_link.eap.util.j.b.b((String)string, (boolean)true);
        if (list == null) {
            arrayList.add(null);
        } else {
            arrayList.add(list);
        }
        List list2 = com.tp_link.eap.util.j.b.b((String)string, (boolean)false);
        if (list2 == null) {
            arrayList.add(null);
        } else {
            arrayList.add(list2);
        }
        return arrayList;
    }

    @Override
    public OperationResponse getCustomizeRegionParam(ControlType controlType, JSONObject reqObj) {
        HashMap<Integer, List<List<RegionWireParam>>> hashMap = new HashMap<Integer, List<List<RegionWireParam>>>();
        hashMap.put(276, this.getRegionWireParams(276));
        hashMap.put(841, this.getRegionWireParams(841));
        return new OperationResponse(ResErrorCode.a, hashMap);
    }

    @Override
    public OperationResponse getRegionParam(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.e.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        Object object = jSONObject.opt("region");
        if (!(object instanceof Integer)) {
            return new OperationResponse(ResErrorCode.d);
        }
        Integer n2 = (Integer)object;
        HashMap<String, List<List<RegionWireParam>>> hashMap = new HashMap<String, List<List<RegionWireParam>>>();
        hashMap.put("data", this.getRegionWireParams(n2));
        return new OperationResponse(ResErrorCode.a, hashMap);
    }

    @Override
    public OperationResponse getRegionForLimit(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.e.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        Object object = jSONObject.opt("region");
        if (!(object instanceof Integer)) {
            return new OperationResponse(ResErrorCode.d);
        }
        Integer n2 = (Integer)object;
        String string = com.tp_link.eap.util.j.a.a((Integer)n2);
        List list = com.tp_link.eap.util.j.b.c((String)string);
        HashMap<String, List> hashMap = new HashMap<String, List>();
        hashMap.put("data", list);
        return new OperationResponse(ResErrorCode.a, hashMap);
    }
}

